﻿using System.Windows.Forms;
using YusakuClassLibrary;

namespace RunRunGridLiner.View.ChainEffect
{

    /// <summary>
    /// ファイル保存ダイアログ表示チェーンエフェクト
    /// </summary>
    public class SaveFileChainEffect : IChainEffect
    {

        #region 変数定義

        /// <summary>
        /// オーナーフォーム
        /// </summary>
        private Form m_ownerForm;

        /// <summary>
        /// 保存先ファイル名
        /// </summary>
        private string m_fileName;

        #endregion

        #region コンストラクタ

        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="ownerForm">オーナーフォーム</param>
        public SaveFileChainEffect(Form ownerForm)
        {
            m_ownerForm = ownerForm;
        }

        #endregion

        #region チェーンエフェクト実装

        /// <summary>
        /// 効果を発動します。
        /// </summary>
        /// <returns>発動結果</returns>
        public IChainEffect.ActivateResult Activate()
        {

            /* ファイル保存ダイアログを生成 */
            using SaveFileDialog dialog = new();
            dialog.Filter = "PNGファイル (*.png)|*.png";
            dialog.RestoreDirectory = true;

            /* 保存先が選択された場合、保存先ファイル名を取得 */
            if (dialog.ShowDialog(m_ownerForm) == DialogResult.OK)
            {
                m_fileName = dialog.FileName;
                return IChainEffect.ActivateResult.Success;
            }

            return IChainEffect.ActivateResult.Fail;

        }

        /// <summary>
        /// 値を取得します。
        /// </summary>
        /// <returns>値</returns>
        public object GetValue()
        {
            return m_fileName;
        }

        #endregion

    }

}
