﻿using System.Collections.Generic;
using System.ComponentModel;
using System.Runtime.CompilerServices;

namespace YusakuClassLibrary
{

    /// <summary>
    /// カードステータス
    /// </summary>
    /// <typeparam name="T">ステータスの型</typeparam>
    public class CardStatus<T> : INotifyPropertyChanged
    {

        #region プロパティ

        /// <summary>
        /// 値
        /// </summary>
        private T? _value;

        /// <summary>
        /// 値を取得または設定します。
        /// </summary>
        public T? Value
        {
            get { return _value; }
            set { SetProperty(value); }
        }

        #endregion

        #region イベント

        /// <summary>
        /// プロパティ変更イベントハンドラ
        /// </summary>
        public event PropertyChangedEventHandler? PropertyChanged;

        #endregion

        #region プロパティ設定

        /// <summary>
        /// 指定した値をプロパティに設定します。
        /// 値が変更された場合、プロパティ変更時イベントを発生させます。
        /// </summary>
        /// <typeparam name="T">プロパティの型</typeparam>
        /// <param name="value">変更する値</param>
        /// <param name="propertyName">通知するプロパティ名(CallerMemberNameにより自動で設定されます)</param>
        /// <returns></returns>
        private bool SetProperty(T? value, [CallerMemberName] string? propertyName = null)
        {

            /* 同じ値の場合、終了 */
            if (EqualityComparer<T>.Default.Equals(_value, value))
            {
                return false;
            }

            /* プロパティに値を設定 */
            _value = value;

            /* プロパティ変更時イベントを発生 */
            PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(propertyName));

            return true;

        }

        #endregion

    }

}
