﻿using System;
using System.Drawing;
using System.Windows.Forms;

namespace RunRunGridLiner.CustomControl
{

    /// <summary>
    /// パラメータパネル
    /// </summary>
    public partial class PanelParam : UserControl
    {

        #region プロパティ

        /// <summary>
        /// グリッドの幅コントロールを取得します。
        /// </summary>
        public Control GridWidth { get => NumericGridWidth; }

        /// <summary>
        /// グリッドの高さコントロールを取得します。
        /// </summary>
        public Control GridHeight { get => NumericGridHeight; }

        /// <summary>
        /// グリッドのX座標コントロールを取得します。
        /// </summary>
        public Control GridX { get => NumericGridX; }

        /// <summary>
        /// グリッドのY座標コントロールを取得します。
        /// </summary>
        public Control GridY { get => NumericGridY; }

        /// <summary>
        /// 線の幅コントロールを取得します。
        /// </summary>
        public Control LineWidth { get => NumericLineWidth; }

        /// <summary>
        /// 線の色コントロールを取得します。
        /// </summary>
        public Control LineColor { get => ButtonLineColor; }

        /// <summary>
        /// 線の透明度コントロールを取得します。
        /// </summary>
        public Control LineAlpha { get => NumericLineAlpha; }

        #endregion

        #region コンストラクタ

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public PanelParam()
        {

            /* コントロール初期化 */
            InitializeComponent();

            /* プロパティ設定 */
            NumericGridWidth.Maximum = 1000;
            NumericGridWidth.Minimum = 1;
            NumericGridWidth.Value = 100;
            NumericGridHeight.Maximum = 1000;
            NumericGridHeight.Minimum = 1;
            NumericGridHeight.Value = 100;
            NumericGridX.Maximum = 100;
            NumericGridX.Minimum = -100;
            NumericGridX.Value = 0;
            NumericGridY.Maximum = 100;
            NumericGridY.Minimum = -100;
            NumericGridY.Value = 0;
            NumericLineWidth.Maximum = 100;
            NumericLineWidth.Minimum = 1;
            NumericLineWidth.Value = 10;
            NumericLineAlpha.Maximum = 255;
            NumericLineAlpha.Minimum = 0;
            NumericLineAlpha.Value = 255;
            ButtonLineColor.ForeColor = Color.Black;

        }

        #endregion

        #region コントロールイベント

        /// <summary>
        /// 線の色を変更ボタンクリック時イベント
        /// </summary>
        /// <param name="sender">イベント送信元</param>
        /// <param name="e">イベントパラメータ</param>
        private void ButtonLineColor_Click(object sender, EventArgs e)
        {

            /* 色選択ダイアログを生成 */
            using ColorDialog dialog = new();
            dialog.CustomColors = new int[] { ColorTranslator.ToWin32(ButtonLineColor.ForeColor) };

            /* ダイアログを表示 */
            if (dialog.ShowDialog(this) == DialogResult.OK)
            {
                ButtonLineColor.ForeColor = dialog.Color;
            }

        }

        #endregion

    }

}
