﻿namespace YusakuClassLibrary
{

    /// <summary>
    /// チェーンエフェクト
    /// </summary>
    public interface IChainEffect
    {

        #region 定数定義

        /// <summary>
        /// 発動結果の戻り値を指定します。
        /// </summary>
        public enum ActivateResult
        {

            /// <summary>
            /// 成功
            /// </summary>
            Success,

            /// <summary>
            /// 失敗
            /// </summary>
            Fail,

            /// <summary>
            /// キャンセル
            /// </summary>
            Cancel

        }

        #endregion

        #region チェーンエフェクト実装

        /// <summary>
        /// 効果を発動します。
        /// </summary>
        /// <returns>発動結果</returns>
        public abstract ActivateResult Activate();

        /// <summary>
        /// 値を取得します。
        /// </summary>
        /// <returns>値</returns>
        public abstract object GetValue();

        #endregion

    }

}
