﻿using System.Windows.Forms;
using YusakuClassLibrary;

namespace RunRunGridLiner.View.ChainEffect
{

    /// <summary>
    /// ファイル選択ダイアログ表示チェーンエフェクト
    /// </summary>
    public class OpenFileChainEffect : IChainEffect
    {

        #region 変数定義

        /// <summary>
        /// オーナーフォーム
        /// </summary>
        private Form m_ownerForm;

        /// <summary>
        /// 選択ファイル名
        /// </summary>
        private string m_fileName;

        #endregion

        #region コンストラクタ

        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="ownerForm">オーナーフォーム</param>
        public OpenFileChainEffect(Form ownerForm)
        {
            m_ownerForm = ownerForm;
        }

        #endregion

        #region チェーンエフェクト実装

        /// <summary>
        /// 効果を発動します。
        /// </summary>
        /// <returns>発動結果</returns>
        public IChainEffect.ActivateResult Activate()
        {

            /* ファイルオープンダイアログを生成 */
            using OpenFileDialog dialog = new();
            dialog.Filter = "画像ファイル (*.jpg;*.jpeg;*.png;*gif;*.bmp)|*.jpg;*.jpeg;*.png;*gif;*.bmp|すべてのファイル (*.*)|*.*";
            dialog.RestoreDirectory = true;

            /* ファイルが選択された場合、ファイル名を取得 */
            if (dialog.ShowDialog(m_ownerForm) == DialogResult.OK)
            {
                m_fileName = dialog.FileName;
                return IChainEffect.ActivateResult.Success;
            }

            return IChainEffect.ActivateResult.Fail;

        }

        /// <summary>
        /// 値を取得します。
        /// </summary>
        /// <returns>値</returns>
        public object GetValue()
        {
            return m_fileName;
        }

        #endregion

    }

}
